module Conn ( create_sock, acceptConn, findCommand ) where
import Control.Concurrent
import Control.Concurrent.MVar
import Control.Monad
import Data.Map as M
import Data.Set as S
import System.IO
import Network.Socket
import Text.Regex.Posix
import Directory
import Random
import List
import Global

address :: String
address = ".hclueplay"

stripLn :: String -> String
stripLn str = let ( _, _, rest ) = str =~ "^[ \t\n\r]*" :: ( String, String, String ); ( result, _, _ ) = rest =~ "[ \t\n\r]*$" :: ( String, String, String ) in result

findCommand :: Handle -> String -> Task
findCommand handle line = if command `M.member` commands then ( commands ! command ) else readonly . const $ hPutStrLn handle $ "Invalid command " ++ command
	where
		command = if Prelude.null worded then "" else head worded
		worded = words line
		readonly :: ( State -> IO () ) -> State -> IO State
		readonly f state = f state >> return state
		commands :: Map String Task
		getStrList = hPutStr handle . unlines . ( ++ [ "" ] ) . Prelude.map ( ">" ++ )
		clearPl state = state { playlist = [] }
		alterModes f state = state { modes = f ( head $ tail worded ) $ modes state }
		getLines :: IO [ String ]
		getLines = hGetLine handle >>= ( \line -> if line =~ "^>" then getLines >>= return . ( ( stripLn $ tail line ) : ) else return [] )
		append state = getLines >>= \lines -> return $ state { playlist = playlist state ++ lines }
		shuffle state = ( randomize $ playlist state ) >>= \pl -> return $ state { playlist = pl }
		randomize :: Ord a => [ a ] -> IO [ a ]
		randomize list = mapM ( \f -> ( ( randomIO :: IO Int ) >>= \n -> return ( n, f ) ) ) list >>= ( return . Prelude.map ( \( _, f ) -> f ) . sort )
		commands = M.fromList $ [
			( "playlist", readonly $ getStrList . playlist ),
			( "history", readonly $ getStrList . history ),
			( "act", readonly $ hPutStrLn handle . act ),
			( "getmodes", readonly $ getStrList . S.toList . modes ),
			( "setmode", return . alterModes S.insert ),
			( "unsetmode", return . alterModes S.delete ),
			( "clear", return . clearPl ),
			( "append", append ),
			( "load", append . clearPl ),
			( "next", Global.next ),
			( "prev", prev ),
			( "stop", \state -> putStrLn "Stop" >> stop state ),
			( "playpause", \state -> putStrLn "Pause" >> playPause state ),
			( "shuffle", shuffle ),
			( "help", readonly $ const $ getStrList $ keys commands )
			]

readCommand :: Worker -> Handle -> MVar Bool -> IO ()
readCommand worker handle response = hGetLine handle >>= ( sendCommand worker response . findCommand handle )

handleConn :: Worker -> Handle -> IO ()
handleConn worker handle = hSetBuffering handle LineBuffering >> ( newEmptyMVar >>= \response -> catch ( forever $ readCommand worker handle response ) $ const $ hClose handle )

acceptConn :: Socket -> Worker -> IO ()
acceptConn socket mvar = do
	( newSock, _ ) <- accept socket
	socketToHandle newSock ReadWriteMode >>= forkIO . handleConn mvar >> return ()

create_sock :: IO Socket
create_sock = catch ( removeFile address ) ( const $ return () ) >> socket AF_UNIX Stream 0 >>= ( \socket -> ( bindSocket socket $ SockAddrUnix address ) >> ( listen socket 10 ) >> ( return socket ) )
