module Work ( getWorker, getState ) where
import Control.Concurrent
import Control.Concurrent.MVar
import Data.Set
import Global

getState :: Worker -> IO State
getState worker = return $ State { playlist = [], history = [], act = "", modes = empty, player = Player NullPlayer, sWorker = worker, startNext = 0 }

getWorker :: IO Worker
getWorker = newEmptyMVar >>= ( \mvar -> ( getState mvar >>= forkIO . tasks mvar ) >> return mvar )
		where
			tasks worker state = takeMVar worker >>= ( \task -> task state >>= tasks worker )
