/*
   Sticky
   Copyright (C) 2006 Michal Vaner (michal.vaner@kdemail.net)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   he Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QPalette>
#include "control.h"
#include "show.h"
#include "event.h"

Control *control = 0L;

Control::Control() {
	setupUi( this );
	connect( allButt, SIGNAL(clicked()), ::show->allButt, SLOT(click()) );
	connect( nearButt, SIGNAL(clicked()), ::show->nearButt, SLOT(click()) );
	connect( lostButt, SIGNAL(clicked()), ::show->lostButt, SLOT(click()) );
	connect( todoButt, SIGNAL(clicked()), ::show->todoButt, SLOT(click()) );
	connect( allButt, SIGNAL(clicked()), ::show, SLOT(show()) );
	connect( nearButt, SIGNAL(clicked()), ::show, SLOT(show()) );
	connect( lostButt, SIGNAL(clicked()), ::show, SLOT(show()) );
	connect( todoButt, SIGNAL(clicked()), ::show, SLOT(show()) );
	connect( events, SIGNAL(update()), SLOT(update()) );
	QPalette p = nearButt->palette();
	p.setColor( QPalette::Active, QPalette::ButtonText, Qt::yellow );
	p.setColor( QPalette::Inactive, QPalette::ButtonText, Qt::yellow );
	nearButt->setPalette( p );
	p = lostButt->palette();
	p.setColor( QPalette::Active, QPalette::ButtonText, Qt::red );
	p.setColor( QPalette::Inactive, QPalette::ButtonText, Qt::red );
	lostButt->setPalette( p );
	p = todoButt->palette();
	p.setColor( QPalette::Active, QPalette::ButtonText, Qt::blue );
	p.setColor( QPalette::Inactive, QPalette::ButtonText, Qt::blue );
	todoButt->setPalette( p );
}

void Control::update() {
	allButt->setText( QString( "%1" ).arg( events->events().count() ) );
	nearButt->setText( QString( "%1" ).arg( events->near().count() ) );
	lostButt->setText( QString( "%1" ).arg( events->late().count() ) );
	todoButt->setText( QString( "%1" ).arg( events->todo().count() ) );
	nearButt->setEnabled( nearButt->text() != "0" );
	lostButt->setEnabled( lostButt->text() != "0" );
	todoButt->setEnabled( todoButt->text() != "0" );
}

#include "moc_control.cpp"
