/*
   Sticky
   Copyright (C) 2006 Michal Vaner (michal.vaner@kdemail.net)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   he Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef EVENT_H
#define EVENT_H

#include <QObject>
#include <QDate>
#include <QTime>

class QSettings;

class Event : public QObject {
	Q_OBJECT;
	private:
		QString mText, mName;
		QDateTime mDate;
		bool mHasTime, mHasDate, mTodo;
		bool lastTodo, lastNear, lastLate;
	public:
		Event();
		Event( QSettings &s );
		void save( QSettings &s );
		const QString &text() const { return mText; }
		const QString &name() const { return mName; }
		bool isLate() const, isNear() const, isTodo() const { return mTodo; };
		bool isReallyLate() const;
		QDate date() const { return mDate.date(); }
		QTime time() const { return mDate.time(); }
		const QDateTime &dateTime() const { return mDate; }
		bool hasTime() const { return mHasDate && mHasTime; }
		bool hasDate() const { return mHasDate; }
	public slots:
		void setText( const QString & );
		void setName( const QString & );
		void setDate( bool, const QDate & );
		void setTime( bool, const QTime & );
		void setTodo( bool );
	private slots:
		void checkState();
	signals:
		void stateChanged();
};

class Events : public QObject {
	Q_OBJECT;
	private:
		QList < Event * > mEvents;
	public:
		QList< Event * > events();
		QList< Event * > near();
		QList< Event * > late();
		QList< Event * > todo();
	public slots:
		void addEvent( Event * );
		void delEvent( Event * );
		void load();
		void save();
	signals:
		void update();
} extern *events;

#endif
