/*
   Sticky
   Copyright (C) 2006 Michal Vaner (michal.vaner@kdemail.net)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   he Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SHOW_H
#define SHOW_H

#include "ui_show.h"
#include <QMainWindow>

class Event;

class Show : public QMainWindow, public Ui::Show {
	Q_OBJECT;
	private:
		Event *selected;
		bool locked;
	public:
		Show();
	private slots:
		void update();
		void on_addButt_clicked();
		void on_remButt_clicked();
		void on_itemList_currentItemChanged( QListWidgetItem *, QListWidgetItem * );
		void on_nameEdit_textEdited( const QString &text );
		void on_dateCheck_toggled( bool );
		void on_dateEdit_dateChanged( const QDate & );
		void on_timeCheck_toggled( bool );
		void on_timeEdit_timeChanged( const QTime & );
		void on_textEdit_textChanged();
		void on_todoCheck_toggled( bool );
	protected:
		virtual void closeEvent( QCloseEvent * );
} extern *show;

#endif
